document.addEventListener('click', function(e){
  const btn = e.target.closest('[data-trv-toggle]');
  if(!btn) return;
  const review = btn.closest('.trv-review');
  if(!review) return;
  const text = review.querySelector('.trv-review-text');
  if(!text) return;
  text.classList.toggle('trv-clamp');
  btn.textContent = text.classList.contains('trv-clamp') ? 'Lees meer' : 'Lees minder';
});

// Carousel arrows
document.addEventListener('click', function(e){
  const prev = e.target.closest('[data-trv-prev]');
  const next = e.target.closest('[data-trv-next]');
  if(!prev && !next) return;
  const wrap = e.target.closest('[data-trv-carousel]');
  if(!wrap) return;
  const track = wrap.querySelector('[data-trv-track]');
  if(!track) return;
  const slide = track.querySelector('.trv-carousel-slide');
  const step = slide ? (slide.getBoundingClientRect().width + 12) : 320;
  track.scrollBy({ left: prev ? -step : step, behavior: 'smooth' });
});

document.addEventListener('DOMContentLoaded', function(){
  document.querySelectorAll('[data-trv-carousel]').forEach(function(wrap){
    const track = wrap.querySelector('[data-trv-track]');
    if(!track) return;
    // hide arrows if not scrollable
    if(track.scrollWidth <= track.clientWidth + 2) wrap.classList.add('trv-no-scroll');
  });
});
