<?php
/**
 * Plugin Name: Taxireview Reviews & Badges
 * Description: Toon je Taxireview.nl reviews als badge, grid, carousel, wall en QR — zonder iframe — met altijd een "Schrijf een review" CTA.
 * Version: 0.1.7
 * Author: Taxireview.nl
 * License: GPLv2 or later
 * Text Domain: taxireview-wp-embed
 */
if (!defined('ABSPATH')) { exit; }

define('TRV_WP_EMBED_VERSION', '0.1.7');
define('TRV_WP_EMBED_PLUGIN_FILE', __FILE__);
define('TRV_WP_EMBED_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('TRV_WP_EMBED_PLUGIN_URL', plugin_dir_url(__FILE__));

require_once TRV_WP_EMBED_PLUGIN_DIR . 'includes/class-trv-settings.php';
require_once TRV_WP_EMBED_PLUGIN_DIR . 'includes/class-trv-api-client.php';
require_once TRV_WP_EMBED_PLUGIN_DIR . 'includes/class-trv-render.php';
require_once TRV_WP_EMBED_PLUGIN_DIR . 'includes/class-trv-shortcodes.php';

add_action('init', function() { TRV_Shortcodes::register(); });
add_action('admin_menu', function() { TRV_Settings::register_menu(); });
add_action('admin_init', function() { TRV_Settings::register_settings(); });

add_action('wp_enqueue_scripts', function() {
  wp_register_style('trv-wp-embed', TRV_WP_EMBED_PLUGIN_URL . 'assets/taxireview.css', [], TRV_WP_EMBED_VERSION);
});

add_action('wp_enqueue_scripts', function() { wp_enqueue_script('trv-wp-embed', TRV_WP_EMBED_PLUGIN_URL . 'assets/taxireview.js', [], TRV_WP_EMBED_VERSION, true); });
