<?php
if (!defined('ABSPATH')) { exit; }

class TRV_Shortcodes {
  public static function register() {
    add_shortcode('taxireview_badge', [__CLASS__,'badge']);
    add_shortcode('taxireview_reviews', [__CLASS__,'reviews']);
    add_shortcode('taxireview_wall', [__CLASS__,'wall']);
    add_shortcode('taxireview_qr', [__CLASS__,'qr']);
  }

  private static function client() { $opts = TRV_Settings::get(); return [new TRV_Api_Client($opts), $opts]; }

  public static function badge($atts=[]) {
    [$client,$opts]=self::client();
    $summary=$client->get_summary(false);
    if(is_wp_error($summary)) return '<div class="trv-error">'.esc_html($summary->get_error_message()).'</div>';
    return TRV_Render::badge($summary,'badge',$opts,$client);
  }

  public static function reviews($atts=[]) {
    $atts = shortcode_atts(['layout'=>'grid','limit'=>6,'min_rating'=>1,'verified' => 0], $atts, 'taxireview_reviews');
    [$client,$opts]=self::client();
    $summary=$client->get_summary(false);
    if(is_wp_error($summary)) return '<div class="trv-error">'.esc_html($summary->get_error_message()).'</div>';

    $reviews=$client->get_reviews(['limit'=>intval($atts['limit']),'page'=>1,'min_rating'=>intval($atts['min_rating']),'verified'=>intval($atts['verified'])], false);
    if(is_wp_error($reviews)) return '<div class="trv-error">'.esc_html($reviews->get_error_message()).'</div>';

    $layout = in_array($atts['layout'], ['grid','carousel'], true) ? $atts['layout'] : 'grid';
    return ($layout==='carousel') ? TRV_Render::reviews_carousel($summary,$reviews,'carousel',$opts,$client)
                                 : TRV_Render::reviews_grid($summary,$reviews,'grid',$opts,$client);
  }

  public static function wall($atts=[]) {
    $atts = shortcode_atts(['per_page'=>10,'min_rating'=>1,'verified' => 0], $atts, 'taxireview_wall');
    [$client,$opts]=self::client();
    $summary=$client->get_summary(false);
    if(is_wp_error($summary)) return '<div class="trv-error">'.esc_html($summary->get_error_message()).'</div>';

    $page = isset($_GET['trv_page']) ? max(1, intval($_GET['trv_page'])) : 1;
    $per = max(1, min(50, intval($atts['per_page'])));

    $reviews=$client->get_reviews(['limit'=>$per,'page'=>$page,'min_rating'=>intval($atts['min_rating']),'verified'=>intval($atts['verified'])], false);
    if(is_wp_error($reviews)) return '<div class="trv-error">'.esc_html($reviews->get_error_message()).'</div>';

    return TRV_Render::wall($summary,$reviews,'wall',$opts,$client,$per);
  }

  public static function qr($atts=[]) {
    $atts = shortcode_atts(['size'=>220], $atts, 'taxireview_qr');
    [$client,$opts]=self::client();
    $summary=$client->get_summary(false);
    if(is_wp_error($summary)) return '<div class="trv-error">'.esc_html($summary->get_error_message()).'</div>';
    return TRV_Render::qr($summary,'qr',$opts,$client,intval($atts['size']));
  }
}
